import java.lang.StringBuffer;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import types.FrameBuffer;
import types.Rahmen;
 
public class Bucket {
    FrameBuffer m_Buffer;
    public Bucket(FrameBuffer buffer) {
        m_Buffer = buffer;
    }
    public void paint(Graphics g,Rectangle frame) {
        int iAnz = m_Buffer.size();
        int iMax = m_Buffer.getMaxSize();
        // Paint filled area
        g.setColor(Color.black);
        g.fillRect(frame.x,frame.y,frame.width,frame.height-1);
        // Paint border
        g.setColor(Color.red);
        g.drawLine(frame.x,frame.y,frame.x,frame.y+frame.height);
        g.drawLine(frame.x,frame.y+frame.height,frame.x+frame.width,frame.y+frame.height);
        g.drawLine(frame.x+frame.width,frame.y+frame.height,frame.x+frame.width,frame.y);
        // Paint contents of buffer
        // Select font
        int iFontSize = frame.height/iMax-1;
        if (iFontSize>13)
            iFontSize = 13;
        Font font=new Font("Helvetica",Font.PLAIN,iFontSize);
        g.setFont(font);
        Rectangle rahmen = new Rectangle(frame.x+3,frame.y+(iMax-1)*frame.height/iMax,frame.width-6,frame.height/iMax-2);
        synchronized (m_Buffer) {
            for (Enumeration e=m_Buffer.elements();e.hasMoreElements();) {
                g.setColor(Color.yellow);
                g.fillRect(rahmen.x,rahmen.y,rahmen.width,rahmen.height);
                g.setColor(Color.red);
                g.drawRect(rahmen.x,rahmen.y,rahmen.width,rahmen.height);
                g.setColor(Color.black);
                Rahmen data = (Rahmen)e.nextElement();
                if (data.Destroyed()) {
                    g.setColor(Color.red);
                    g.drawLine(rahmen.x,rahmen.y,rahmen.x+rahmen.width,rahmen.y+rahmen.height);
                    g.drawLine(rahmen.x,rahmen.y+rahmen.height,rahmen.x+rahmen.width,rahmen.y);
                }
                if (data.iKind()==Rahmen.DATA) {
                    StringBuffer temp = new StringBuffer(0);
                    temp.append(data.data());
                    g.drawString(temp.toString(),rahmen.x+rahmen.width/2-iFontSize/2+2,rahmen.y+rahmen.height/2+iFontSize/2);
                }
                else {
                    g.drawString("Ack:"+Integer.toString(data.seqNrAck()),rahmen.x+rahmen.width/2-iFontSize,rahmen.y+rahmen.height/2+iFontSize/2);
                }

                rahmen.translate(0,-frame.height/iMax);
            }
        }
    }
}
